<?php
/**
 * VW Dentist: Block Patterns
 *
 * @package VW Dentist
 * @since   1.0.0
 */

/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {

	register_block_pattern_category(
		'vw-dentist',
		array( 'label' => __( 'VW Dentist', 'vw-dentist' ) )
	);
}

/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {
	register_block_pattern(
		'vw-dentist/banner-section',
		array(
			'title'      => __( 'Banner Section', 'vw-dentist' ),
			'categories' => array( 'vw-dentist' ),
			'content'    => "<!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/banner.png\",\"id\":7079,\"dimRatio\":0,\"align\":\"full\",\"className\":\"main-banner\"} -->\n<div class=\"wp-block-cover alignfull main-banner\" style=\"background-image:url(" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/banner.png)\"><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":4,\"className\":\"mt-0 mb-1\",\"fontSize\":\"normal\"} -->\n<h4 class=\"has-text-align-left mt-0 mb-1 has-normal-font-size\">Lorem Ipsum Dolor</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"textAlign\":\"left\",\"level\":1,\"className\":\"mt-0 mb-2\",\"fontSize\":\"large\"} -->\n<h1 class=\"has-text-align-left mt-0 mb-2 has-large-font-size\">Lorem Ipsum is Simply Dummy Text</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"className\":\"mt-0 mb-2 text-left\",\"style\":{\"color\":{\"text\":\"#0d374c\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-left mt-0 mb-2 text-left has-text-color\" style=\"color:#0d374c;font-size:14px\">&nbsp;Lorem Ipsum has been the industrys standard. &nbsp;Lorem Ipsum has been the industrys standard. &nbsp;Lorem Ipsum has been the industrys standard.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"mt-1\"} -->\n<div class=\"wp-block-buttons mt-1\"><!-- wp:button {\"style\":{\"color\":{\"background\":\"#13455e\"}}} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-background\" style=\"background-color:#13455e\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->",
		)
	);

	register_block_pattern(
		'vw-dentist/features-section',
		array(
			'title'      => __( 'Features Section', 'vw-dentist' ),
			'categories' => array( 'vw-dentist' ),
			'content'    => "<!-- wp:cover {\"overlayColor\":\"white\",\"align\":\"full\",\"className\":\"features-outer-box\"} -->\n<div class=\"wp-block-cover alignfull has-white-background-color has-background-dim features-outer-box\"><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":5,\"className\":\"text-center\",\"textColor\":\"white\",\"fontSize\":\"normal\"} -->\n<h5 class=\"has-text-align-center text-center has-white-color has-text-color has-normal-font-size\">Awesome Features</h5>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"className\":\"mt-3 mb-5\",\"style\":{\"color\":{\"text\":\"#07a7e3\"},\"typography\":{\"fontSize\":35}}} -->\n<h2 class=\"has-text-align-center mt-3 mb-5 has-text-color\" style=\"color:#07a7e3;font-size:35px\">Our Dental Clinic Features</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns {\"align\":\"wide\",\"className\":\"m-0\"} -->\n<div class=\"wp-block-columns alignwide m-0\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"align\":\"center\",\"id\":7095,\"width\":80,\"height\":80,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large is-resized\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/features-icon1.png\" alt=\"\" class=\"wp-image-7095\" width=\"80\" height=\"80\"/></figure></div>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"className\":\"mb-3\",\"fontSize\":\"medium\",\"style\":{\"color\":{\"text\":\"#13455e\"}}} -->\n<h3 class=\"has-text-align-center mb-3 has-text-color has-medium-font-size\" style=\"color:#13455e\">Awesome Features Title 1</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"text-center mb-0\",\"style\":{\"color\":{\"text\":\"#a5aeb4\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center text-center mb-0 has-text-color\" style=\"color:#a5aeb4;font-size:14px\">Lorem Ipsum has been the industrys standard.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"center\",\"className\":\"mt-0\"} -->\n<div class=\"wp-block-buttons aligncenter mt-0\"><!-- wp:button {\"borderRadius\":0,\"style\":{\"color\":{\"text\":\"#07a7e3\"}}} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-color no-border-radius\" style=\"color:#07a7e3\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"align\":\"center\",\"id\":7100,\"width\":80,\"height\":80,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large is-resized\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/features-icon2.png\" alt=\"\" class=\"wp-image-7100\" width=\"80\" height=\"80\"/></figure></div>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"className\":\"mb-3\",\"fontSize\":\"medium\",\"style\":{\"color\":{\"text\":\"#13455e\"}}} -->\n<h3 class=\"has-text-align-center mb-3 has-text-color has-medium-font-size\" style=\"color:#13455e\">Awesome Features Title 2</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"text-center mb-0\",\"style\":{\"color\":{\"text\":\"#a5aeb4\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center text-center mb-0 has-text-color\" style=\"color:#a5aeb4;font-size:14px\">Lorem Ipsum has been the industrys standard.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"center\",\"className\":\"mt-0\"} -->\n<div class=\"wp-block-buttons aligncenter mt-0\"><!-- wp:button {\"borderRadius\":0,\"style\":{\"color\":{\"text\":\"#07a7e3\"}}} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-color no-border-radius\" style=\"color:#07a7e3\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"align\":\"center\",\"id\":7102,\"width\":80,\"height\":80,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large is-resized\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/features-icon3.png\" alt=\"\" class=\"wp-image-7102\" width=\"80\" height=\"80\"/></figure></div>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"className\":\"mb-3\",\"fontSize\":\"medium\",\"style\":{\"color\":{\"text\":\"#13455e\"}}} -->\n<h3 class=\"has-text-align-center mb-3 has-text-color has-medium-font-size\" style=\"color:#13455e\">Awesome Features Title 3</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"text-center mb-0\",\"style\":{\"color\":{\"text\":\"#a5aeb4\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center text-center mb-0 has-text-color\" style=\"color:#a5aeb4;font-size:14px\">Lorem Ipsum has been the industrys standard.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"center\",\"className\":\"mt-0\"} -->\n<div class=\"wp-block-buttons aligncenter mt-0\"><!-- wp:button {\"borderRadius\":0,\"style\":{\"color\":{\"text\":\"#07a7e3\"}}} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-color no-border-radius\" style=\"color:#07a7e3\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"align\":\"center\",\"id\":7104,\"width\":80,\"height\":80,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large is-resized\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/features-icon4.png\" alt=\"\" class=\"wp-image-7104\" width=\"80\" height=\"80\"/></figure></div>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"className\":\"mb-3\",\"fontSize\":\"medium\",\"style\":{\"color\":{\"text\":\"#13455e\"}}} -->\n<h3 class=\"has-text-align-center mb-3 has-text-color has-medium-font-size\" style=\"color:#13455e\">Awesome Features Title 4</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"text-center mb-0\",\"style\":{\"color\":{\"text\":\"#a5aeb4\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center text-center mb-0 has-text-color\" style=\"color:#a5aeb4;font-size:14px\">Lorem Ipsum has been the industrys standard.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"center\",\"className\":\"mt-0\"} -->\n<div class=\"wp-block-buttons aligncenter mt-0\"><!-- wp:button {\"borderRadius\":0,\"style\":{\"color\":{\"text\":\"#07a7e3\"}}} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-color no-border-radius\" style=\"color:#07a7e3\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->",
		)
	);
}